#!/bin/sh

# chkconfig: 345 35 65
# description: LicenceServer 3.0 service start script
#
### BEGIN INIT INFO
# Provides:          licenceserver
# Required-Start:    $remote_fs $syslog
# Required-Stop:     $remote_fs $syslog
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: LicenceServer 3.0
# Description:       LicenceServer 3.0 service start script
### END INIT INFO

ServiceName="LicenceServer"
ServiceFile="licenceserver"
ServicePath="/opt/1C/licence/3.0/"
ServiceBinary=$ServicePath$ServiceFile
StartParams="-r"
StopParams="s"

# Checking root access

if [ "$(id -u)" != "0" ]; then # sh-way
    echo "This script must be run as root"
    exit 1
fi

# System=
if [ -f /etc/redhat-release ]; then
    System=redhat
elif [ -f /etc/debian_version ]; then
    System=debian
else
    echo "Error: Unknown system"
    exit 2
fi

if [ "$System" = "redhat" ]; then
    . /etc/init.d/functions
    
    fail_msg() {
        echo_failure
        echo
    }

    succ_msg() {
        echo_success
        echo
        if [ "$1" ]; then
            tput bold
            echo "$ServiceName service is running $1"
            tput sgr0
        fi
    }

    begin() {
        echo -n "$1"
    }
fi

if [ "$System" = "debian" ]; then

    daemon() {
        start-stop-daemon -S -b -x $ServiceBinary -- $StartParams
    }

    killproc() {
        start-stop-daemon -K -x $ServiceBinary -- $StopParams
    }

    fail_msg() {
        echo failure
        echo
        # echo "Failed"
    }

    succ_msg() {
        echo success
        echo
        if [ "$1" ]; then
            tput bold
            echo "$ServiceName service is running $1"
            tput sgr0
        fi
        # echo "Done $1"
    }
fi

# Service commands

status() {
    RetVal=$(pidof $ServiceFile)
    if [  $RetVal ]; then
        tput bold
        echo "$ServiceName service is running (PID: $RetVal)"
        tput sgr0
    else
        echo "$ServiceName service is not running"
    fi
}

testbinary() {
    test -x "$ServiceBinary" || {
        echo "Cannot run $ServiceBinary"
        exit 1
    }
}

start() {
    Pid=$(pidof $ServiceFile)
    if [ ! $Pid ]; then
	    echo "Starting $ServiceName service...";

	    daemon $ServiceBinary $StartParams & > /dev/null
        RetVal=$?
        sleep 1s
        Pid=$(pidof $ServiceFile)
        if [ $Pid ]; then
            succ_msg "(PID: $Pid)"
        else
            fail_msg
        fi
    else
        tput bold
        echo "$ServiceName service is already running (PID: $Pid)"
        tput sgr0
    fi
    return $Pid
}

stop() {
    Pid=$(pidof $ServiceFile)
    if [ $Pid ]; then
	    echo "Stopping $ServiceName service...";
        killproc $ServiceBinary
        RetVal=$?
        sleep 2s
        Pid=$(pidof $ServiceFile)
        if [ ! $Pid ]; then
            succ_msg
        else
            fail_msg
        fi
    else
        echo "$ServiceName service is not running"
    fi
    return $Pid
}

restart() {
    stop && start
}


case "$1" in
start)
    start
    ;;
stop)
    stop
    ;;
restart)
    restart
    ;;
status)
    status
    ;;
setup)
    ;;
cleanup)
    ;;
*)
    echo "Usage: $0 {start|stop|restart|status}"
    exit 1
esac

exit $RetVal
