#!/bin/sh

# Checking root access

if [ "$(id -u)" != "0" ]; then
    echo "This script must be run as root"
    exit 1
fi

# Script directory

BaseDir=`dirname $0`
BaseDir=`cd $BaseDir;pwd`

# echo -e "\n$HOSTTYPE\n"
# echo -e "$BaseDir\n"
# echo -e "$1\n"

if [ "$(pidof systemd)" ]; then

	echo "Installing for systemd"

	\cp -f $BaseDir/licenceserver.service /lib/systemd/system/licenceserver.service
	chmod 644 /lib/systemd/system/licenceserver.service
	systemctl enable licenceserver

elif [ "$(pidof /sbin/init)" ]; then

	echo "Installing for sysvinit"

	\cp -fp $BaseDir/licenceserver.sh /etc/init.d/licenceserver

	if command -v chkconfig >/dev/null 2>&1; then
		chkconfig --add licenceserver
	elif command -v update-rc.d >/dev/null 2>&1; then
		update-rc.d licenceserver defaults
	else
		echo "Autostart not set: chkconfig / update-rc.d not found"
	fi

fi
